\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{actasmonteiro}[2023/06/06 v1.00]

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{amsart}}
\ProcessOptions\relax
\LoadClass[]{amsart}[1996/10/24]


\def\publname{ACTAS DEL XVII CONGRESO\newline
  DR.~ANTONIO A.~R.~MONTEIRO (2023)}

%% Datos para el footer
\def\shortpublname{Actas del XVII Congreso Dr. Antonio A. R. Monteiro (2023)}
%\def\footervolumeissue{, Vol.~\currentvolume, No.~\currentissue,}

%\def\ISSN{0327-9170}



%% ----------------------------------------------------------------------------
%% Fonts
%% ----------------------------------------------------------------------------
% Usa la fuente Times Roman en math & text
\RequirePackage{mathptmx}
%\usepackage{txfonts}  % Ver LaTeX Companion 2nd ed.
\RequirePackage[T1]{fontenc}


%% ----------------------------------------------------------------------------
%% Copyright
%% ----------------------------------------------------------------------------
\copyrightinfo{}{}



%% ----------------------------------------------------------------------------
%% Logo
%% ----------------------------------------------------------------------------
\def\@logofont{\fontsize{7}{8\p@}\selectfont}        %% un punto más grande que en amsart
\def\article@logo{%
  \set@logo{%
    \publname
    \ifx\@empty\@dateposted \else \@setdateposted\fi
  }%
}

\def\@setdateposted{%
  \newline Published online: \@dateposted}



%% ----------------------------------------------------------------------------
%% Dimensions
%% ----------------------------------------------------------------------------
\RequirePackage{geometry}
\geometry{
	paperwidth=210mm,  % ancho final del papel
	paperheight=297mm, % altura final del papel
	twoside=true,      % two sides, obvio
	tmargin=47mm,      % margen superior (20 deseado + 27 sobrante)
	bmargin=27mm,      % margen inferior
	lmargin=45mm,      % margen interno   (35 deseado + 10 sobrante)  (OK 2008)
	rmargin=25mm,      % margen externo   (valor deseado: 25)  (OK 2008)
	headsep=8mm,       % separación entre el running header y el área de texto 
	footskip=10mm,     % separación entre el pie y el área de texto
	%verbose,           % muestra los valores utilizados
	voffset=-14mm
}


%% ----------------------------------------------------------------------------
%% Header & footer
%% ----------------------------------------------------------------------------
\RequirePackage{fancyhdr}
\pagestyle{fancy}
\renewcommand{\headrulewidth}{.2pt}  % línea delgada bajo el running head
\fancyhf{}  % --- limpia todos los campos

\fancyhead[RE,LO]{}
\fancyhead[CE]{\footnotesize \MakeUppercase{\shortauthors}}
\fancyhead[CO]{\footnotesize \shorttitle}
\fancyhead[RO,LE]{\footnotesize \thepage}

%\fancyfoot[LE,RO]{\scriptsize \textit{\shortpublname\footervolumeissue\ (\currentyear)}}
\fancyfoot[C]{}
\fancyfoot[LO,RE]{}

